<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_contents', function (Blueprint $table) {
            $table->id();
            $table->string('page_key')->unique(); // e.g., 'home_hero_title', 'about_intro'
            $table->string('section')->nullable(); // e.g., 'home', 'about', 'contact'
            $table->string('label'); // Human-readable label
            $table->text('content')->nullable();
            $table->string('type')->default('text'); // text, html, image, etc.
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_contents');
    }
};
